/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import icyllis.modernui.core.mixin.AccessGameRenderer;
import icyllis.modernui.core.mixin.AccessPostChain;
import icyllis.modernui.view.IMuiScreen;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum BlurHandler {
    INSTANCE;

    public static boolean sBlurEffect;
    public static float sAnimationDuration;
    public static float sBlurRadius;
    public static float sBackgroundAlpha;
    private final ResourceLocation bilinearBlur = new ResourceLocation("shaders/post/blur_fast.json");
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private final Set<Class<?>> blacklist = new ObjectArraySet();
    private boolean fadingIn;
    private boolean blurring;
    private boolean screenOpened;
    private float backgroundAlpha;

    public void count(@Nullable Screen nextScreen) {
        boolean blurDisabled;
        boolean excluded;
        if (this.minecraft.field_71441_e == null) {
            return;
        }
        if (nextScreen == null || nextScreen instanceof IMuiScreen) {
            excluded = false;
        } else {
            Class<?> t = nextScreen.getClass();
            excluded = this.blacklist.stream().anyMatch(c -> c.isAssignableFrom(t));
        }
        boolean bl = blurDisabled = excluded || !sBlurEffect;
        if (blurDisabled && excluded && this.blurring) {
            this.minecraft.field_71460_t.func_181022_b();
            this.fadingIn = false;
            this.blurring = false;
        }
        boolean hasGui = nextScreen != null;
        GameRenderer gr = this.minecraft.field_71460_t;
        if (hasGui && !this.blurring && !this.screenOpened) {
            if (!blurDisabled && gr.func_147706_e() == null) {
                ((AccessGameRenderer)gr).callLoadEffect(this.bilinearBlur);
                this.blurring = true;
                if (sAnimationDuration <= 0.0f) {
                    this.updateRadius(sBlurRadius);
                }
            }
            if (sAnimationDuration > 0.0f) {
                this.fadingIn = true;
                this.backgroundAlpha = 0.0f;
            } else {
                this.fadingIn = false;
                this.backgroundAlpha = sBackgroundAlpha;
            }
        } else if (!hasGui && this.blurring) {
            gr.func_181022_b();
            this.fadingIn = false;
            this.blurring = false;
        }
        this.screenOpened = hasGui;
    }

    public void forceBlur() {
        GameRenderer gr;
        if (!sBlurEffect) {
            return;
        }
        if (this.minecraft.field_71441_e != null && (gr = this.minecraft.field_71460_t).func_147706_e() == null) {
            ((AccessGameRenderer)gr).callLoadEffect(this.bilinearBlur);
            this.fadingIn = true;
            this.blurring = true;
        }
    }

    public void loadBlacklist(@Nonnull List<? extends String> names) {
        this.blacklist.clear();
        for (String string : names) {
            try {
                Class<?> clazz = Class.forName(string);
                this.blacklist.add(clazz);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void update(long time) {
        if (this.fadingIn) {
            float p = Math.min((float)time / sAnimationDuration, 1.0f);
            if (this.blurring) {
                this.updateRadius(p * sBlurRadius);
            }
            if (this.backgroundAlpha < sBackgroundAlpha) {
                this.backgroundAlpha = p * sBackgroundAlpha;
            }
            if (p == 1.0f) {
                this.fadingIn = false;
            }
        }
    }

    private void updateRadius(float radius) {
        ShaderGroup effect = this.minecraft.field_71460_t.func_147706_e();
        if (effect == null) {
            return;
        }
        List<Shader> passes = ((AccessPostChain)effect).getPasses();
        for (Shader s2 : passes) {
            s2.func_217624_b().func_216538_b("Progress").func_148090_a(radius);
        }
    }

    public void drawScreenBackground(@Nonnull Screen screen, @Nonnull MatrixStack stack, int x1, int y1, int x2, int y2) {
        int a = (int)(this.backgroundAlpha * 255.0f);
        if (a == 0) {
            return;
        }
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        int z = screen.func_230927_p_();
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        builder.func_227888_a_(matrix, (float)x2, (float)y1, (float)z).func_225586_a_(0, 0, 0, a).func_181675_d();
        builder.func_227888_a_(matrix, (float)x1, (float)y1, (float)z).func_225586_a_(0, 0, 0, a).func_181675_d();
        builder.func_227888_a_(matrix, (float)x1, (float)y2, (float)z).func_225586_a_(0, 0, 0, a).func_181675_d();
        builder.func_227888_a_(matrix, (float)x2, (float)y2, (float)z).func_225586_a_(0, 0, 0, a).func_181675_d();
        builder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)builder);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }
}

